<?php include('includes/header.php'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Our Services - Twin Beam Enterprises</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background: #f8f9fa;
        }

        .hero {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            color: white;
            padding: 80px 20px 60px;
            text-align: center;
        }

        .hero h1 {
            font-size: 2.8em;
            margin-bottom: 15px;
        }

        .hero p {
            font-size: 1.2em;
            opacity: 0.95;
            max-width: 700px;
            margin: 0 auto;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        .service-card {
            background: white;
            border-radius: 12px;
            padding: 40px;
            margin: 30px 0;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .service-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0,0,0,0.15);
        }

        .service-card h2 {
            color: #1e3c72;
            font-size: 2em;
            margin-bottom: 20px;
            border-bottom: 3px solid #2a5298;
            padding-bottom: 10px;
        }

        .service-card h3 {
            color: #2a5298;
            font-size: 1.4em;
            margin: 25px 0 15px;
        }

        .service-card p {
            margin-bottom: 15px;
            color: #555;
        }

        .process-steps {
            background: #f0f4f8;
            border-radius: 8px;
            padding: 25px;
            margin: 20px 0;
        }

        .step {
            margin: 15px 0;
            padding-left: 30px;
            position: relative;
        }

        .step::before {
            content: "✓";
            position: absolute;
            left: 0;
            color: #2a5298;
            font-weight: bold;
            font-size: 1.3em;
        }

        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            margin: 25px 0;
        }

        .feature-box {
            background: #f0f4f8;
            padding: 20px;
            border-radius: 8px;
            border-left: 4px solid #2a5298;
        }

        .feature-box h4 {
            color: #1e3c72;
            margin-bottom: 10px;
        }

        .benefits-list {
            list-style: none;
            margin: 20px 0;
        }

        .benefits-list li {
            padding: 10px 0 10px 30px;
            position: relative;
        }

        .benefits-list li::before {
            content: "→";
            position: absolute;
            left: 0;
            color: #2a5298;
            font-weight: bold;
        }

        .cta-section {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            color: white;
            padding: 60px 20px;
            text-align: center;
            margin-top: 50px;
        }

        .cta-section h2 {
            font-size: 2.2em;
            margin-bottom: 20px;
        }

        .contact-info {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 30px;
            margin-top: 30px;
        }

        .contact-item {
            font-size: 1.1em;
        }

        @media (max-width: 768px) {
            .hero h1 {
                font-size: 2em;
            }

            .service-card {
                padding: 25px;
            }

            .features-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="hero">
        <h1>Our Services</h1>
        <p>Professional, affordable, and real-time solutions tailored to your business needs</p>
    </div>

    <div class="container">
        <!-- Asset Tagging Service -->
        <div class="service-card">
            <h2>Asset Tagging Services</h2>
            <p>Asset tagging is the process of attaching durable aluminum tags to your assets for easy identification and comprehensive tracking. Each tag bears your company name, logo, unique asset number, and a scannable QR code or barcode that stores detailed information about that specific asset.</p>

            <h3>Our Asset Tagging Process</h3>
            <div class="process-steps">
                <div class="step">
                    <strong>Verification:</strong> We identify and verify all assets that need to be tagged
                </div>
                <div class="step">
                    <strong>Tagging:</strong> Each verified asset is assigned a unique sequential tag number and physically tagged
                </div>
                <div class="step">
                    <strong>Fixed Asset Register Development:</strong> We create a comprehensive register capturing detailed information for every tagged asset
                </div>
                <div class="step">
                    <strong>Reconciliation:</strong> The new register is reconciled with your existing records to identify any disparities
                </div>
            </div>

            <h3>Key Benefits</h3>
            <ul class="benefits-list">
                <li>Facilitates efficient management of physical capital and informed decision-making</li>
                <li>Ensures maximum efficiency of equipment and employee productivity</li>
                <li>Prevents theft by increasing asset security</li>
                <li>Reduces downtime through better planning and maintenance scheduling</li>
                <li>Identifies assets that need repair or replacement</li>
            </ul>

            <p><strong>Our Tags:</strong> We provide extremely durable anodized aluminum tags that stick permanently on glass, plastic, metal, wood, and other surfaces. They're acetone-activated and designed for long-lasting performance.</p>
        </div>

        <!-- Asset Management System -->
        <div class="service-card">
            <h2>Asset Management System</h2>
            <p>Our easy-to-use database solution provides a central point for storing and retrieving all your asset records with a familiar, user-friendly interface.</p>

            <div class="features-grid">
                <div class="feature-box">
                    <h4>Features</h4>
                    <ul style="list-style: none; padding-left: 0;">
                        <li>• Track asset information, descriptions, brands, models, manufacturers, and serial numbers</li>
                        <li>• Include file attachments and notes</li>
                        <li>• Issue and return assets to/from personnel</li>
                        <li>• Automated asset depreciation</li>
                        <li>• Maintain electronic service logs</li>
                    </ul>
                </div>
                <div class="feature-box">
                    <h4>Benefits</h4>
                    <ul style="list-style: none; padding-left: 0;">
                        <li>• Manage disposal and approval processes</li>
                        <li>• Track who has an asset and return dates</li>
                        <li>• Account for all assets when employees leave</li>
                        <li>• Maintain a central repository for manuals and instructions</li>
                        <li>• Track vendors and contacts</li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Hardware and Software Services -->
        <div class="service-card">
            <h2>Hardware & Software Supply and Systems Evolution Audit</h2>
            <p>We help institutions overcome hardware and software challenges through expert guidance and comprehensive support services.</p>

            <h3>Our Solutions Include:</h3>
            <ul class="benefits-list">
                <li>Hardware and software upgrades for Local Area Networks (LAN) and Wide Area Networks (WAN)</li>
                <li>Troubleshooting support for complex technical issues</li>
                <li>Minimum hardware specification recommendations for various tasks</li>
                <li>Appropriate software and application recommendations to meet your specific needs</li>
                <li>Systems evolution audits to optimize your IT infrastructure</li>
            </ul>
        </div>

        <!-- Networking Services -->
        <div class="service-card">
            <h2>Networking Services</h2>
            <p>Comprehensive networking solutions to keep your business connected and running smoothly.</p>

            <div class="features-grid">
                <div class="feature-box">
                    <h4>Network Services</h4>
                    <ul style="list-style: none; padding-left: 0;">
                        <li>• Network evolution surveys</li>
                        <li>• End-to-end network termination</li>
                        <li>• Server setup and configurations</li>
                    </ul>
                </div>
                <div class="feature-box">
                    <h4>Infrastructure Setup</h4>
                    <ul style="list-style: none; padding-left: 0;">
                        <li>• Local Area Network (LAN) setup</li>
                        <li>• Wide Area Network (WAN) setup</li>
                        <li>• Wired to wireless LAN conversion</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

   
</body>
</html>

<?php include('includes/footer.php'); ?>