<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit();
}
$conn = new mysqli("localhost", "root", "", "DEFMIS");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Reports</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
<div class="container">
  <h2 class="mb-4 text-primary">Admin Reports</h2>

  <!-- Tabs -->
  <ul class="nav nav-tabs mb-4" id="reportTabs" role="tablist">
    <li class="nav-item" role="presentation">
      <button class="nav-link active" id="appointments-tab" data-bs-toggle="tab" data-bs-target="#appointments" type="button" role="tab">Appointments</button>
    </li>
    <li class="nav-item" role="presentation">
      <button class="nav-link" id="contacts-tab" data-bs-toggle="tab" data-bs-target="#contacts" type="button" role="tab">Contacts</button>
    </li>
  </ul>

  <div class="tab-content" id="reportTabsContent">
    <!-- Appointments Tab -->
    <div class="tab-pane fade show active" id="appointments" role="tabpanel">
      <div class="d-flex justify-content-between align-items-center mb-2">
        <h4 class="text-primary">Appointments</h4>
        <div>
          <a href="export_appointments_excel.php" class="btn btn-sm btn-success">Export Excel</a>
          <a href="export_appointments_pdf.php" class="btn btn-sm btn-danger">Export PDF</a>
          <a href="export_appointments_csv.php" class="btn btn-sm btn-warning">Export CSV</a>
        </div>
      </div>
      <table class="table table-bordered table-striped">
        <thead class="bg-primary text-white">
          <tr>
            <th>#</th>
            <th>Name</th>
            <th>Email</th>
            <th>Department</th>
            <th>Date</th>
            <th>Created At</th>
            <th>Reply</th>
            <th>Replied?</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php
          $res = $conn->query("SELECT * FROM appointments ORDER BY created_at DESC");
          $count = 1;
          while ($row = $res->fetch_assoc()) {
              $reply = htmlspecialchars($row['reply'] ?? '');
              $repliedStatus = !empty(trim($reply)) ? "<span class='badge bg-success'>Yes</span>" : "<span class='badge bg-danger'>No</span>";
              echo "<tr>
                <td>{$count}</td>
                <td>" . htmlspecialchars($row['name']) . "</td>
                <td>" . htmlspecialchars($row['email']) . "</td>
                <td>" . htmlspecialchars($row['department']) . "</td>
                <td>" . htmlspecialchars($row['date']) . "</td>
                <td>" . htmlspecialchars($row['created_at']) . "</td>
                <td>" . nl2br($reply) . "</td>
                <td>{$repliedStatus}</td>
                <td>
                  <a href='reply_appointment.php?id={$row['id']}' class='btn btn-sm btn-success mb-1'>Reply</a>
                  <a href='edit_appointment.php?id={$row['id']}' class='btn btn-sm btn-primary mb-1'>Edit</a>
                  <a href='delete_appointment.php?id={$row['id']}' onclick='return confirm(\"Delete this appointment?\")' class='btn btn-sm btn-danger'>Delete</a>
                </td>
              </tr>";
              $count++;
          }
          ?>
        </tbody>
      </table>
    </div>

    <!-- Contacts Tab -->
    <div class="tab-pane fade" id="contacts" role="tabpanel">
      <div class="d-flex justify-content-between align-items-center mb-2 mt-4">
        <h4 class="text-primary">Contact Messages</h4>
        <div>
          <a href="export_contacts_excel.php" class="btn btn-sm btn-success">Export Excel</a>
          <a href="export_contacts_pdf.php" class="btn btn-sm btn-danger">Export PDF</a>
          <a href="export_contacts_csv.php" class="btn btn-sm btn-warning">Export CSV</a>
        </div>
      </div>
      <table class="table table-bordered table-striped">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Name</th>
            <th>Email</th>
            <th>Subject</th>
            <th>Message</th>
            <th>Reply</th>
            <th>Received At</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php
          $res = $conn->query("SELECT * FROM contacts ORDER BY created_at DESC");
          $count = 1;
          while ($row = $res->fetch_assoc()) {
              echo "<tr>
                <td>{$count}</td>
                <td>" . htmlspecialchars($row['name']) . "</td>
                <td>" . htmlspecialchars($row['email']) . "</td>
                <td>" . htmlspecialchars($row['subject']) . "</td>
                <td>" . nl2br(htmlspecialchars($row['message'])) . "</td>
                <td>" . nl2br(htmlspecialchars($row['reply'])) . "</td>
                <td>" . htmlspecialchars($row['created_at']) . "</td>
                <td>
                  <a href='reply_contact.php?id={$row['id']}' class='btn btn-sm btn-success mb-1'>Reply</a>
                  <a href='edit_contact.php?id={$row['id']}' class='btn btn-sm btn-primary mb-1'>Edit</a>
                  <a href='delete_contact.php?id={$row['id']}' onclick='return confirm(\"Delete this message?\")' class='btn btn-sm btn-danger'>Delete</a>
                </td>
              </tr>";
              $count++;
          }
          ?>
        </tbody>
      </table>
    </div>
  </div>

  <a href="logout.php" class="btn btn-outline-secondary mt-4">Logout</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
