<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DEFMIS - Best Medical at Retirement</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
        }

        /* Top Navigation Bar */
        .top-nav {
            background-color: #f8f8f8;
            padding: 10px 0;
            border-bottom: 1px solid #e0e0e0;
        }

        .top-nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 40px;
        }

        .logo {
            display: flex;
            flex-direction: column;
            gap: 2px;
        }

        .logo-name {
            font-size: 28px;
            font-weight: bold;
            color: #8b1538;
            letter-spacing: 1px;
        }

        .logo-motto {
            font-size: 11px;
            color: #666;
            font-style: italic;
            letter-spacing: 0.5px;
        }

        .top-nav-links {
            display: flex;
            gap: 30px;
            align-items: center;
        }

        .top-nav-links .nav-item {
            position: relative;
        }

        .top-nav-links a {
            text-decoration: none;
            color: #333;
            font-size: 14px;
            transition: color 0.3s;
        }

        .top-nav-links a:hover {
            color: #8b1538;
        }

        .top-nav-actions {
            display: flex;
            gap: 15px;
            align-items: center;
        }

        .btn-help {
            background-color: #8b1538;
            color: white;
            padding: 8px 20px;
            border-radius: 20px;
            text-decoration: none;
            font-size: 14px;
            transition: background-color 0.3s;
        }

        .btn-help:hover {
            background-color: #6d1129;
        }

        .btn-callback {
            background-color: #333;
            color: white;
            padding: 8px 20px;
            border-radius: 20px;
            text-decoration: none;
            font-size: 14px;
            transition: background-color 0.3s;
        }

        .btn-callback:hover {
            background-color: #555;
        }

        .search-icon, .language-selector {
            cursor: pointer;
            font-size: 18px;
            position: relative;
        }

        /* Language Dropdown */
        .language-dropdown {
            display: none;
            position: absolute;
            top: 100%;
            right: 0;
            background: white;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            margin-top: 8px;
            min-width: 150px;
            z-index: 1000;
        }

        .language-dropdown.show {
            display: block;
        }

        .language-item {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px 16px;
            cursor: pointer;
            transition: background-color 0.2s;
            text-decoration: none;
            color: #333;
            font-size: 14px;
        }

        .language-item:hover {
            background-color: #f5f5f5;
        }

        .language-item:first-child {
            border-radius: 8px 8px 0 0;
        }

        .language-item:last-child {
            border-radius: 0 0 8px 8px;
        }

        .language-flag {
            width: 24px;
            height: 16px;
            font-size: 20px;
        }

        /* Callback Dropdown */
        .callback-wrapper {
            position: relative;
        }

        .callback-dropdown {
            display: none;
            position: absolute;
            top: 100%;
            right: 0;
            background: white;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            margin-top: 8px;
            min-width: 200px;
            z-index: 1000;
        }

        .callback-dropdown.show {
            display: block;
        }

        .callback-item {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px 16px;
            cursor: pointer;
            transition: background-color 0.2s;
            text-decoration: none;
            color: #333;
            font-size: 14px;
            border-bottom: 1px solid #f0f0f0;
        }

        .callback-item:last-child {
            border-bottom: none;
            border-radius: 0 0 8px 8px;
        }

        .callback-item:first-child {
            border-radius: 8px 8px 0 0;
        }

        .callback-item:hover {
            background-color: #f5f5f5;
        }

        .callback-icon {
            font-size: 18px;
        }

        /* Dropdown Styles for Top Nav */
        .top-nav .dropdown-menu {
            background-color: white;
            border: 1px solid #e0e0e0;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        .top-nav .dropdown-item {
            color: #333;
            padding: 10px 20px;
            font-size: 14px;
        }

        .top-nav .dropdown-item:hover {
            background-color: #f8f8f8;
            color: #8b1538;
        }

        /* Main Navigation Bar */
        .main-nav {
            background-color: #8b1538;
            padding: 0;
        }

        .main-nav-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 40px;
        }

        .main-nav .navbar-nav {
            flex-direction: row;
            gap: 40px;
        }

        .main-nav .nav-link {
            color: white;
            font-size: 14px;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            padding: 15px 0;
            transition: opacity 0.3s;
        }

        .main-nav .nav-link:hover,
        .main-nav .nav-link.active {
            opacity: 0.8;
            color: white;
        }

        .main-nav .dropdown-menu {
            background-color: #6d1129;
            border: none;
            margin-top: 0;
        }

        .main-nav .dropdown-item {
            color: white;
            padding: 10px 20px;
            font-size: 13px;
        }

        .main-nav .dropdown-item:hover {
            background-color: #8b1538;
            color: white;
        }

        .main-nav-actions {
            display: flex;
            gap: 15px;
            align-items: center;
        }

        .btn-buy, .btn-self-service {
            background-color: transparent;
            color: white;
            padding: 8px 20px;
            border: 1px solid white;
            border-radius: 20px;
            text-decoration: none;
            font-size: 13px;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: background-color 0.3s;
        }

        .btn-buy:hover, .btn-self-service:hover {
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
        }

        /* Submenu styles */
        .dropdown-submenu {
            position: relative;
        }

        .dropdown-submenu > .dropdown-menu {
            top: 0;
            left: 100%;
            margin-top: -1px;
            display: none;
        }

        .dropdown-submenu:hover > .dropdown-menu {
            display: block;
        }

        .dropdown-submenu .dropdown-toggle::after {
            content: '›';
            float: right;
            margin-left: 10px;
            border: none;
        }

        /* Self Service Portal Dropdown */
        .portal-dropdown-wrapper {
            position: relative;
        }

        .portal-dropdown {
            display: none;
            position: absolute;
            top: 100%;
            right: 0;
            background: white;
            border-radius: 8px;
            width: 280px;
            max-height: 450px;
            overflow-y: auto;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            z-index: 9999;
            margin-top: 5px;
        }

        .portal-dropdown.show {
            display: block;
        }

        .portal-header {
            padding: 15px 18px;
            border-bottom: 2px solid #8b1538;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            background: white;
            z-index: 1;
        }

        .portal-header h2 {
            font-size: 16px;
            font-weight: 600;
            color: #333;
            margin: 0;
        }

        .portal-close {
            background: none;
            border: none;
            font-size: 22px;
            cursor: pointer;
            color: #333;
            line-height: 1;
            padding: 0;
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .portal-close:hover {
            color: #8b1538;
        }

        .portal-links {
            padding: 8px;
        }

        .portal-link {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 12px 15px;
            margin-bottom: 6px;
            border: 1.5px solid #8b1538;
            border-radius: 6px;
            text-decoration: none;
            color: #8b1538;
            font-weight: 600;
            font-size: 13px;
            transition: all 0.3s;
        }

        .portal-link:hover {
            background-color: #8b1538;
            color: white;
        }

        .portal-link span {
            font-size: 16px;
        }

        /* Responsive */
        @media (max-width: 991px) {
            .top-nav-links {
                display: none;
            }
            
            .main-nav .navbar-nav {
                flex-direction: column;
                gap: 0;
            }
            
            .main-nav .nav-link {
                padding: 10px 0;
            }
            
            .dropdown-submenu > .dropdown-menu {
                position: static;
                display: none;
                margin-left: 20px;
            }
            
            .dropdown-submenu.show > .dropdown-menu {
                display: block;
            }
        }
    </style>
</head>
<body>
    <!-- Top Navigation -->
    <nav class="top-nav">
        <div class="top-nav-container">
            <div class="logo">
                <a href="index.php" style="text-decoration: none;">
                    <div class="logo-name">DEFMIS</div>
                    <div class="logo-motto">best medical at retirement</div>
                </a>
            </div>
            
            <div class="top-nav-links">
                <!-- About Us Dropdown -->
                <div class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">About Us</a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="about/company-profile.php">Company Profile</a></li>
                        <li><a class="dropdown-item" href="about/our-history.php">Our History</a></li>
                        <li><a class="dropdown-item" href="about/leadership.php">Leadership Team</a></li>
                        <li><a class="dropdown-item" href="about/mission-vision.php">Mission & Vision</a></li>
                        <li><a class="dropdown-item" href="about/awards.php">Awards & Recognition</a></li>
                    </ul>
                </div>
                
                <!-- Newsroom Dropdown -->
                <div class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">Newsroom</a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="newsroom/press-releases.php">Press Releases</a></li>
                        <li><a class="dropdown-item" href="newsroom/media-kit.php">Media Kit</a></li>
                        <li><a class="dropdown-item" href="newsroom/events.php">Events</a></li>
                        <li><a class="dropdown-item" href="newsroom/announcements.php">Announcements</a></li>
                    </ul>
                </div>
                
                <!-- Careers Dropdown -->
                <div class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">Careers</a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="careers/current-openings.php">Current Openings</a></li>
                        <li><a class="dropdown-item" href="careers/why-join-us.php">Why Join Us</a></li>
                        <li><a class="dropdown-item" href="careers/application-process.php">Application Process</a></li>
                        <li><a class="dropdown-item" href="careers/internships.php">Internships</a></li>
                    </ul>
                </div>
                
                <!-- Blog Dropdown -->
                <div class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">Blog</a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="blog/insurance-tips.php">Insurance Tips</a></li>
                        <li><a class="dropdown-item" href="blog/financial-advice.php">Financial Advice</a></li>
                        <li><a class="dropdown-item" href="blog/health-wellness.php">Health & Wellness</a></li>
                        <li><a class="dropdown-item" href="blog/success-stories.php">Success Stories</a></li>
                    </ul>
                </div>
                
                <!-- Fraud Awareness Dropdown -->
                <div class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">Fraud Awareness</a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="fraud/common-scams.php">Common Scams</a></li>
                        <li><a class="dropdown-item" href="fraud/how-to-protect.php">How to Protect Yourself</a></li>
                        <li><a class="dropdown-item" href="fraud/report-fraud.php">Report Fraud</a></li>
                        <li><a class="dropdown-item" href="fraud/fraud-alerts.php">Fraud Alerts</a></li>
                    </ul>
                </div>
            </div>
            
            <div class="top-nav-actions">
                <a href="help.php" class="btn-help">Help</a>
                
                <!-- Request A Callback Dropdown -->
                <div class="callback-wrapper">
                    <a href="#" class="btn-callback" id="callbackBtn">Request A Callback</a>
                    <div class="callback-dropdown" id="callbackDropdown">
                        <a href="tel:+254709949000" class="callback-item">
                            <span class="callback-icon">📞</span>
                            <span>Call Us: 0709949000</span>
                        </a>
                        <a href="callback-form.php" class="callback-item">
                            <span class="callback-icon">📝</span>
                            <span>Schedule Callback</span>
                        </a>
                        <a href="mailto:Talk2Us@jubileekenya.com" class="callback-item">
                            <span class="callback-icon">✉️</span>
                            <span>Email Us</span>
                        </a>
                        <a href="https://wa.me/254709949000" class="callback-item" target="_blank">
                            <span class="callback-icon">💬</span>
                            <span>WhatsApp</span>
                        </a>
                    </div>
                </div>
                
              <div class="dropdown">
    <span class="search-icon" id="searchDropdown" 
          data-bs-toggle="dropdown" aria-expanded="false"
          style="cursor:pointer; font-size:20px;">
        🔍
    </span>

    <div class="dropdown-menu dropdown-menu-end p-3 shadow" 
         aria-labelledby="searchDropdown" style="min-width:260px;">

        <!-- Direct Category Links -->
        <label class="form-label mb-1">Go to section:</label>
        <select class="form-select form-select-sm mb-3" onchange="goToCategory(this.value)">
            <option value="">-- Select Section --</option>
            <option value="hospitals.php">DEFMIS Hospitals</option>
            <option value="clinics.php">Clinics / Branches</option>
            <option value="doctors.php">Doctors / Specialists</option>
            <option value="products.php">Insurance Products</option>
            <option value="benefits.php">Benefits / Covers</option>
            <option value="claims.php">Claims & Approvals</option>
        </select>

        <hr>
      

    </div>
</div>


                <div style="position: relative;">
                    <span class="language-selector" id="languageBtn">
    <img src="img/icon/kenya.png" alt="Kenya" style="width:22px; height:auto; border-radius:3px;">
</span>

                    <div class="language-dropdown" id="languageDropdown">
                        <a href="?lang=ke" class="language-item">
                            <span class="language-flag">🇰🇪</span>
                            <span>Kenya</span>
                        </a>
                        <a href="?lang=tz" class="language-item">
                            <span class="language-flag">🇹🇿</span>
                            <span>Tanzania</span>
                        </a>
                        <a href="?lang=ug" class="language-item">
                            <span class="language-flag">🇺🇬</span>
                            <span>Uganda</span>
                        </a>
                        <a href="?lang=group" class="language-item">
                            <span class="language-flag" style="color: #dc143c;">🏢</span>
                            <span>Group</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Navigation -->
    <nav class="navbar navbar-expand-lg main-nav">
        <div class="container-fluid main-nav-container">
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain"
                    aria-controls="navbarMain" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarMain">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <!-- Life & Pension Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?= in_array($current_page, ['life-pension.php']) ? 'active' : '' ?>" 
                           href="#" role="button" data-bs-toggle="dropdown">LIFE & PENSION</a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="life-pension/life-insurance.php">Life Insurance</a></li>
                            <li><a class="dropdown-item" href="life-pension/pension-plans.php">Pension Plans</a></li>
                            <li><a class="dropdown-item" href="life-pension/retirement-savings.php">Retirement Savings</a></li>
                            <li><a class="dropdown-item" href="life-pension/education-plans.php">Education Plans</a></li>
                            <li><a class="dropdown-item" href="life-pension/group-life.php">Group Life</a></li>
                        </ul>
                    </li>
                    
                    <!-- Health Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?= in_array($current_page, ['health.php']) ? 'active' : '' ?>" 
                           href="#" role="button" data-bs-toggle="dropdown">HEALTH</a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="health/individual-health.php">Individual Health</a></li>
                            <li><a class="dropdown-item" href="health/family-health.php">Family Health</a></li>
                            <li><a class="dropdown-item" href="health/group-health.php">Group Health</a></li>
                            <li><a class="dropdown-item" href="health/international-cover.php">International Cover</a></li>
                            <li><a class="dropdown-item" href="health/dental-optical.php">Dental & Optical</a></li>
                        </ul>
                    </li>
                    
                    <!-- General Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?= in_array($current_page, ['general.php']) ? 'active' : '' ?>" 
                           href="#" role="button" data-bs-toggle="dropdown">GENERAL</a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="general/motor-insurance.php">Motor Insurance</a></li>
                            <li><a class="dropdown-item" href="general/home-insurance.php">Home Insurance</a></li>
                            <li><a class="dropdown-item" href="general/travel-insurance.php">Travel Insurance</a></li>
                            <li><a class="dropdown-item" href="general/business-insurance.php">Business Insurance</a></li>
                            <li><a class="dropdown-item" href="general/personal-accident.php">Personal Accident</a></li>
                        </ul>
                    </li>
                    
                    <!-- Asset Management Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?= in_array($current_page, ['asset-management.php']) ? 'active' : '' ?>" 
                           href="#" role="button" data-bs-toggle="dropdown">ASSET MANAGEMENT</a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="asset/investment-plans.php">Investment Plans</a></li>
                            <li><a class="dropdown-item" href="asset/unit-trusts.php">Unit Trusts</a></li>
                            <li><a class="dropdown-item" href="asset/wealth-management.php">Wealth Management</a></li>
                            <li><a class="dropdown-item" href="asset/portfolio-management.php">Portfolio Management</a></li>
                            <li><a class="dropdown-item" href="asset/financial-planning.php">Financial Planning</a></li>
                            <li><a class="dropdown-item" href="wellness/health-programs.php">Health Programs</a></li>
                            <li><a class="dropdown-item" href="wellness/fitness-tips.php">Fitness Tips</a></li>
                            <li><a class="dropdown-item" href="wellness/nutrition-advice.php">Nutrition Advice</a></li>
                            <li><a class="dropdown-item" href="wellness/mental-health.php">Mental Health</a></li>
                            <li><a class="dropdown-item" href="wellness/wellness-events.php">Wellness Events</a></li>
                        </ul>
                    </li>
                    
                 <!-- Wellness Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?= in_array($current_page, ['wellness.php']) ? 'active' : '' ?>" 
                           href="#" role="button" data-bs-toggle="dropdown">WELLNESS</a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="wellness/health-programs.php">Health Programs</a></li>
                            <li><a class="dropdown-item" href="wellness/fitness-tips.php">Fitness Tips</a></li>
                            <li><a class="dropdown-item" href="wellness/nutrition-advice.php">Nutrition Advice</a></li>
                            <li><a class="dropdown-item" href="wellness/mental-health.php">Mental Health</a></li>
                            <li><a class="dropdown-item" href="wellness/wellness-events.php">Wellness Events</a></li>
                        </ul>
                    </li>
                </ul>
                
                <div class="main-nav-actions">
                    <a href="buy.php" class="btn-buy">
                        <span>👤</span> Buy Now
                    </a>
                    
                    <!-- Self Service Dropdown -->
                    <div class="portal-dropdown-wrapper">
                        <a href="#" class="btn-self-service" id="selfServiceBtn">
                            <span>👤</span> Self Service
                        </a>
                        
                        <div class="portal-dropdown" id="portalDropdown">
                            <div class="portal-header">
                                <h2>Self Service Portal</h2>
                                <button class="portal-close" id="closePortal">&times;</button>
                            </div>
                            <div class="portal-links">
                                <a href="self-service/j-force.php" class="portal-link">
                                    J-Force
                                    <span>→</span>
                                </a>
                                <a href="self-service/customer-portal-life.php" class="portal-link">
                                    Customer Portal Life
                                    <span>→</span>
                                </a>
                                <a href="self-service/jamhub-digital.php" class="portal-link">
                                    JAMHub Digital Portal
                                    <span>→</span>
                                </a>
                                <a href="self-service/customer-portal-pension.php" class="portal-link">
                                    Customer Portal Pension
                                    <span>→</span>
                                </a>
                                <a href="self-service/agents-portal-life.php" class="portal-link">
                                    Agents Portal Life
                                    <span>→</span>
                                </a>
                                <a href="self-service/agents-online-general.php" class="portal-link">
                                    Agents Online General
                                    <span>→</span>
                                </a>
                                <a href="self-service/pensions-trustee.php" class="portal-link">
                                    Pensions Trustee
                                    <span>→</span>
                                </a>
                                <a href="self-service/how-to-make-payments.php" class="portal-link">
                                    How to Make Payments
                                    <span>→</span>
                                </a>
                                <a href="self-service/reimbursement.php" class="portal-link">
                                    Reimbursement
                                    <span>→</span>
                                </a>
                                <a href="self-service/last-expense.php" class="portal-link">
                                    Last Expense
                                    <span>→</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function goToCategory(page) {
    if (page !== "") {
        window.location.href = page;
    }
}

function submitSearch() {
    let type = document.getElementById("searchType").value;
    let query = document.getElementById("searchQuery").value.trim();

    if (query === "") {
        alert("Please type something to search.");
        return;
    }

    window.location.href = "search.php?type=" + type + "&q=" + encodeURIComponent(query);
}
        
        // Request A Callback Dropdown
        const callbackBtn = document.getElementById('callbackBtn');
        const callbackDropdown = document.getElementById('callbackDropdown');

        if (callbackBtn && callbackDropdown) {
            callbackBtn.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                callbackDropdown.classList.toggle('show');
                // Close other dropdowns
                if (languageDropdown) languageDropdown.classList.remove('show');
            });

            // Close callback dropdown when clicking outside
            document.addEventListener('click', function(e) {
                if (!callbackDropdown.contains(e.target) && e.target !== callbackBtn) {
                    callbackDropdown.classList.remove('show');
                }
            });
        }

        // Language Selector Dropdown
        const languageBtn = document.getElementById('languageBtn');
        const languageDropdown = document.getElementById('languageDropdown');

        if (languageBtn && languageDropdown) {
            languageBtn.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                languageDropdown.classList.toggle('show');
                // Close other dropdowns
                if (callbackDropdown) callbackDropdown.classList.remove('show');
            });

            // Close language dropdown when clicking outside
            document.addEventListener('click', function(e) {
                if (!languageDropdown.contains(e.target) && e.target !== languageBtn) {
                    languageDropdown.classList.remove('show');
                }
            });
        }

        // Self Service Portal Dropdown
        const portalDropdown = document.getElementById('portalDropdown');
        const selfServiceBtn = document.getElementById('selfServiceBtn');
        const closePortal = document.getElementById('closePortal');

        selfServiceBtn.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            portalDropdown.classList.toggle('show');
            // Close other dropdowns if open
            if (languageDropdown) languageDropdown.classList.remove('show');
            if (callbackDropdown) callbackDropdown.classList.remove('show');
        });

        closePortal.addEventListener('click', function(e) {
            e.stopPropagation();
            portalDropdown.classList.remove('show');
        });

        // Close dropdown when clicking outside
        document.addEventListener('click', function(e) {
            if (!portalDropdown.contains(e.target) && e.target !== selfServiceBtn) {
                portalDropdown.classList.remove('show');
            }
        });

        // Prevent dropdown from closing when clicking inside
        portalDropdown.addEventListener('click', function(e) {
            e.stopPropagation();
        });

        // Enable submenu toggle for mobile
        document.querySelectorAll('.dropdown-submenu .dropdown-toggle').forEach(function (element) {
            element.addEventListener('click', function (e) {
                e.preventDefault();
                const nextMenu = this.nextElementSibling;
                if (nextMenu && nextMenu.classList.contains('dropdown-menu')) {
                    nextMenu.classList.toggle('show');
                }
            });
        });

        // Close submenus when main menu closes
        document.querySelectorAll('.dropdown').forEach(function (dropdown) {
            dropdown.addEventListener('hidden.bs.dropdown', function () {
                this.querySelectorAll('.dropdown-menu.show').forEach(function (subMenu) {
                    subMenu.classList.remove('show');
                });
            });
        });
    </script>
</body>
</html>