<footer style="background-color: #0a5c11ff;" class="text-white mt-5 pt-4 pb-3"> 
  <div class="container">
    <div class="row gy-4">

      <!-- About Twin Beam -->
      <div class="col-md-4">
        <h5 class="fw-bold mb-3">About Twin Beam Enterprises</h5>
        <p>
          Twin Beam Enterprises is a registered company in Kenya specializing in cost-effective solutions including asset tagging, computers and accessories, networking, printing/branding services, and office stationeries.
        </p>
      </div>

      <!-- Quick Links -->
      <div class="col-md-2">
        <h5 class="fw-bold mb-3">Quick Links</h5>
        <ul class="list-unstyled">
          <li><a href="index.php" class="text-white text-decoration-none d-block mb-1 hover-accent">Home</a></li>
          <li><a href="about.php" class="text-white text-decoration-none d-block mb-1 hover-accent">About Us</a></li>
          <li><a href="products.php" class="text-white text-decoration-none d-block mb-1 hover-accent">Products</a></li>
          <li><a href="services.php" class="text-white text-decoration-none d-block mb-1 hover-accent">Services</a></li>
          <li><a href="faq.php" class="text-white text-decoration-none d-block mb-1 hover-accent">FAQs</a></li>
          <li><a href="quote.php" class="text-white text-decoration-none d-block mb-1 hover-accent">Request A Quote</a></li>
        </ul>
      </div>

      <!-- Contact Info -->
      <div class="col-md-3">
        <h5 class="fw-bold mb-3">Contact Info</h5>
        <p class="mb-1"><i class="bi bi-geo-alt-fill me-2"></i>Twin Beam Enterprises, Kenya</p>
        <p class="mb-1"><i class="bi bi-telephone-fill me-2"></i>+254 721 586 198</p>
        <p class="mb-1"><i class="bi bi-telephone-fill me-2"></i>+254 746 630 003</p>
        <p class="mb-1"><i class="bi bi-telephone-fill me-2"></i>+254 735 055 857</p>
        <p class="mb-1"><i class="bi bi-envelope-fill me-2"></i>twinbeamenterprises@gmail.com</p>
      </div>

      <!-- Newsletter -->
      <div class="col-md-3">
        <h5 class="fw-bold mb-3">Newsletter</h5>
        <form>
          <div class="mb-2">
            <input type="email" class="form-control form-control-sm rounded-3" placeholder="Email address" aria-label="Email address" required>
          </div>
          <button type="submit" class="btn btn-light btn-sm w-100 rounded-3 fw-semibold">Subscribe</button>
        </form>
      </div>

    </div>

    <hr class="border-light my-4">

    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
      <small class="mb-0">&copy; <?php echo date("Y"); ?> <strong><a href="index.php" style="color: inherit; text-decoration: none; transition: color 0.3s;" onmouseover="this.style.color='#667eea'" onmouseout="this.style.color='inherit'">Zanox tech</a></strong>. All rights reserved.</small>
      <div class="social-icons">
        <a href="#" class="text-white me-3" aria-label="Facebook"><i class="bi bi-facebook fs-5"></i></a>
        <a href="#" class="text-white me-3" aria-label="YouTube"><i class="bi bi-youtube fs-5"></i></a>
        <a href="#" class="text-white me-3" aria-label="Twitter"><i class="bi bi-twitter fs-5"></i></a>
        <a href="#" class="text-white" aria-label="LinkedIn"><i class="bi bi-linkedin fs-5"></i></a>
      </div>
    </div>
  </div>
</footer>

<!-- Accent Hover and Social Icons -->
<style>
  .hover-accent:hover {
    color: rgb(0, 204, 31); /* accent green */
    text-decoration: underline;
  }

  .social-icons a:hover {
    color: rgb(0, 204, 31);
    transition: color 0.3s ease;
  }

  /* Chatbot Styles */
  .chatbot-button {
    position: fixed;
    bottom: 20px;
    right: 20px;
    width: 50px;
    height: 50px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    cursor: pointer;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
    z-index: 1000;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
  }

  .chatbot-button:hover {
    transform: scale(1.1);
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.4);
  }

  .chatbot-button.active {
    background: #dc3545;
  }

  .chatbot-container {
    position: fixed;
    bottom: 80px;
    right: 20px;
    width: 320px;
    max-width: calc(100vw - 40px);
    height: 450px;
    background: white;
    border-radius: 12px;
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.2);
    z-index: 999;
    display: none;
    flex-direction: column;
    overflow: hidden;
    animation: slideUp 0.3s ease;
  }

  @keyframes slideUp {
    from {
      opacity: 0;
      transform: translateY(20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }

  .chatbot-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 15px;
    display: flex;
    align-items: center;
    justify-content: space-between;
  }

  .chatbot-header-info {
    display: flex;
    align-items: center;
    gap: 10px;
  }

  .chatbot-avatar {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    background: white;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #667eea;
    font-size: 16px;
    font-weight: bold;
  }

  .chatbot-title h4 {
    margin: 0;
    font-size: 14px;
    font-weight: 600;
  }

  .chatbot-title p {
    margin: 0;
    font-size: 11px;
    opacity: 0.9;
  }

  .chatbot-close {
    background: none;
    border: none;
    color: white;
    font-size: 20px;
    cursor: pointer;
    padding: 0;
    width: 25px;
    height: 25px;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .chatbot-messages {
    flex: 1;
    padding: 15px;
    overflow-y: auto;
    background: #f8f9fa;
  }

  .message {
    margin-bottom: 12px;
    display: flex;
    gap: 8px;
    animation: fadeIn 0.3s ease;
  }

  @keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
  }

  .message.bot {
    justify-content: flex-start;
  }

  .message.user {
    justify-content: flex-end;
  }

  .message-avatar {
    width: 28px;
    height: 28px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 13px;
    flex-shrink: 0;
  }

  .message-content {
    max-width: 70%;
    padding: 10px 12px;
    border-radius: 12px;
    font-size: 13px;
    line-height: 1.4;
  }

  .message.bot .message-content {
    background: white;
    color: #333;
    border-bottom-left-radius: 4px;
  }

  .message.user .message-content {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-bottom-right-radius: 4px;
  }

  .quick-replies {
    padding: 8px 15px;
    display: flex;
    gap: 6px;
    flex-wrap: wrap;
    background: #f8f9fa;
  }

  .quick-reply-btn {
    padding: 6px 12px;
    border: 2px solid #667eea;
    background: white;
    color: #667eea;
    border-radius: 16px;
    font-size: 11px;
    cursor: pointer;
    transition: all 0.3s ease;
  }

  .quick-reply-btn:hover {
    background: #667eea;
    color: white;
  }

  .chatbot-input {
    padding: 12px 15px;
    background: white;
    border-top: 1px solid #e0e0e0;
    display: flex;
    gap: 8px;
  }

  .chatbot-input input {
    flex: 1;
    padding: 10px 14px;
    border: 1px solid #ddd;
    border-radius: 20px;
    font-size: 13px;
    outline: none;
  }

  .chatbot-input input:focus {
    border-color: #667eea;
  }

  .chatbot-send-btn {
    width: 38px;
    height: 38px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 15px;
    transition: transform 0.2s ease;
  }

  .chatbot-send-btn:hover {
    transform: scale(1.1);
  }

  .typing-indicator {
    display: none;
    padding: 10px 12px;
    background: white;
    border-radius: 12px;
    width: fit-content;
  }

  .typing-indicator.active {
    display: block;
  }

  .typing-indicator span {
    height: 6px;
    width: 6px;
    background: #667eea;
    border-radius: 50%;
    display: inline-block;
    margin: 0 2px;
    animation: typing 1.4s infinite;
  }

  .typing-indicator span:nth-child(2) {
    animation-delay: 0.2s;
  }

  .typing-indicator span:nth-child(3) {
    animation-delay: 0.4s;
  }

  @keyframes typing {
    0%, 60%, 100% { transform: translateY(0); }
    30% { transform: translateY(-8px); }
  }

  @media (max-width: 480px) {
    .chatbot-container {
      width: calc(100vw - 30px);
      height: 400px;
      bottom: 75px;
      right: 15px;
    }

    .chatbot-button {
      bottom: 15px;
      right: 15px;
      width: 45px;
      height: 45px;
      font-size: 18px;
    }
  }
</style>

<!-- Bootstrap Icons CDN -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<!-- Chatbot HTML -->
<button class="chatbot-button" id="chatbotToggle">
  <i class="fas fa-comments"></i>
</button>

<div class="chatbot-container" id="chatbotContainer">
  <div class="chatbot-header">
    <div class="chatbot-header-info">
      <div class="chatbot-avatar">TB</div>
      <div class="chatbot-title">
        <h4>TWINBEAM Support</h4>
        <p>We reply instantly</p>
      </div>
    </div>
    <button class="chatbot-close" id="chatbotClose">
      <i class="fas fa-times"></i>
    </button>
  </div>

  <div class="chatbot-messages" id="chatbotMessages">
    <div class="message bot">
      <div class="message-avatar">
        <i class="fas fa-robot"></i>
      </div>
      <div class="message-content">
        👋 Hi! Welcome to Twin Beam. How can I help?
      </div>
    </div>
  </div>

  <div class="quick-replies" id="quickReplies">
    <button class="quick-reply-btn" data-reply="services">Services</button>
    <button class="quick-reply-btn" data-reply="products">Products</button>
    <button class="quick-reply-btn" data-reply="contact">Contact</button>
    <button class="quick-reply-btn" data-reply="quote">Quote</button>
  </div>

  <div class="chatbot-input">
    <input type="text" id="chatbotInput" placeholder="Type your message...">
    <button class="chatbot-send-btn" id="chatbotSend">
      <i class="fas fa-paper-plane"></i>
    </button>
  </div>
</div>

<script>
  const chatbotToggle = document.getElementById('chatbotToggle');
  const chatbotContainer = document.getElementById('chatbotContainer');
  const chatbotClose = document.getElementById('chatbotClose');
  const chatbotMessages = document.getElementById('chatbotMessages');
  const chatbotInput = document.getElementById('chatbotInput');
  const chatbotSend = document.getElementById('chatbotSend');

  // Toggle chatbot on button click
  chatbotToggle.addEventListener('click', () => {
    if (chatbotContainer.style.display === 'flex') {
      chatbotContainer.style.display = 'none';
      chatbotToggle.classList.remove('active');
      chatbotToggle.querySelector('i').className = 'fas fa-comments';
    } else {
      chatbotContainer.style.display = 'flex';
      chatbotToggle.classList.add('active');
      chatbotToggle.querySelector('i').className = 'fas fa-times';
    }
  });

  // Close button
  chatbotClose.addEventListener('click', () => {
    chatbotContainer.style.display = 'none';
    chatbotToggle.classList.remove('active');
    chatbotToggle.querySelector('i').className = 'fas fa-comments';
  });

  const responses = {
    services: {
      text: "Our Services:\n\n🏷️ Asset Tagging\n💻 Hardware & Software\n🌐 Networking Services\n🖨️ Printing/Branding\n📋 Asset Management\n\nWhat interests you?",
      quick: ['Asset Tagging', 'Networking', 'Products', 'Contact']
    },
    products: {
      text: "Our Products:\n\n🏷️ Asset Tags (QR/Barcode)\n📱 Barcode Scanners\n💻 Computers & Laptops\n⌨️ Accessories\n🌐 Networking Products\n📄 Office Stationery\n\nNeed more info?",
      quick: ['Asset Tags', 'Computers', 'Contact']
    },
    contact: {
      text: "📍 Nairobi, Kenya\n📧 twinbeamenterprises@gmail.com\n📞 +254 721 586 198\n📞 +254 746 630 003\n📞 +254 735 055 857\n\n🕒 Mon-Fri, 8AM-5PM",
      quick: ['Quote', 'Services', 'Products']
    },
    quote: {
      text: "Get a quote:\n\n📞 Call: +254 721 586 198\n📧 Email: twinbeamenterprises@gmail.com\n\nWe respond within 24 hours!",
      quick: ['Contact', 'Services', 'Products']
    },
    'asset tagging': {
      text: "Asset Tagging:\n\n✅ Verification\n✅ Tagging\n✅ Register Development\n✅ Reconciliation\n\nDurable aluminum tags with QR/Barcode!",
      quick: ['Asset Tags', 'Quote', 'Services']
    },
    'asset tags': {
      text: "Asset Tags:\n\n🏷️ Durable aluminum\n📊 QR/Barcode options\n🏢 Custom branding\n🔒 Tamper-resistant\n\nFor assets over KES 2,000",
      quick: ['Asset Tagging', 'Quote', 'Products']
    },
    computers: {
      text: "Computers:\n\n💻 Desktops & Laptops\n🖥️ Monitors\n⌨️ Accessories\n🖨️ Printers\n🔋 UPS\n\nBrands: HP, Dell, Toshiba, Compaq",
      quick: ['Quote', 'Products', 'Contact']
    },
    networking: {
      text: "Networking:\n\n🌐 LAN/WAN Setup\n🖥️ Server Config\n📡 Wireless\n🔌 CAT5/6 Cables\n📡 Routers & Switches",
      quick: ['Quote', 'Products', 'Services']
    },
    default: {
      text: "I can help with:\n\n• Services & Products\n• Asset Tagging\n• Computers\n• Networking\n• Quotes\n\nWhat do you need?",
      quick: ['Services', 'Products', 'Contact', 'Quote']
    }
  };

  function addMessage(text, isUser = false) {
    const messageDiv = document.createElement('div');
    messageDiv.className = `message ${isUser ? 'user' : 'bot'}`;
    
    if (!isUser) {
      messageDiv.innerHTML = `
        <div class="message-avatar">
          <i class="fas fa-robot"></i>
        </div>
        <div class="message-content">${text.replace(/\n/g, '<br>')}</div>
      `;
    } else {
      messageDiv.innerHTML = `<div class="message-content">${text}</div>`;
    }
    
    chatbotMessages.appendChild(messageDiv);
    chatbotMessages.scrollTop = chatbotMessages.scrollHeight;
  }

  function showTyping() {
    const typingDiv = document.createElement('div');
    typingDiv.className = 'message bot';
    typingDiv.id = 'typingIndicator';
    typingDiv.innerHTML = `
      <div class="message-avatar">
        <i class="fas fa-robot"></i>
      </div>
      <div class="typing-indicator active">
        <span></span><span></span><span></span>
      </div>
    `;
    chatbotMessages.appendChild(typingDiv);
    chatbotMessages.scrollTop = chatbotMessages.scrollHeight;
  }

  function hideTyping() {
    const typing = document.getElementById('typingIndicator');
    if (typing) typing.remove();
  }

  function updateQuickReplies(replies) {
    const quickRepliesContainer = document.getElementById('quickReplies');
    quickRepliesContainer.innerHTML = '';
    
    if (replies && replies.length > 0) {
      replies.forEach(reply => {
        const btn = document.createElement('button');
        btn.className = 'quick-reply-btn';
        btn.textContent = reply;
        btn.addEventListener('click', () => handleUserMessage(reply));
        quickRepliesContainer.appendChild(btn);
      });
    }
  }

  function handleUserMessage(message) {
    if (!message.trim()) return;
    
    addMessage(message, true);
    chatbotInput.value = '';
    
    showTyping();
    
    setTimeout(() => {
      hideTyping();
      const response = getBotResponse(message);
      addMessage(response.text);
      updateQuickReplies(response.quick);
    }, 800);
  }

  function getBotResponse(message) {
    const lowerMsg = message.toLowerCase();
    
    const keywords = {
      'asset tag': 'asset tags',
      'computer': 'computers',
      'laptop': 'computers',
      'network': 'networking',
      'router': 'networking',
      'switch': 'networking',
      'barcode': 'asset tags',
      'qr': 'asset tags',
      'scanner': 'asset tags',
      'price': 'quote',
      'cost': 'quote'
    };
    
    for (let key in keywords) {
      if (lowerMsg.includes(key)) {
        return responses[keywords[key]] || responses.default;
      }
    }
    
    for (let key in responses) {
      if (lowerMsg.includes(key)) {
        return responses[key];
      }
    }
    
    return responses.default;
  }

  chatbotSend.addEventListener('click', () => {
    handleUserMessage(chatbotInput.value);
  });

  chatbotInput.addEventListener('keypress', (e) => {
    if (e.key === 'Enter') {
      handleUserMessage(chatbotInput.value);
    }
  });

  // Initial quick replies setup
  document.querySelectorAll('.quick-reply-btn').forEach(btn => {
    btn.addEventListener('click', () => {
      handleUserMessage(btn.getAttribute('data-reply'));
    });
  });
</script>