<?php
/**
 * Database Configuration File
 * Include this file in all PHP files that need database connection
 * Usage: require_once('includes/db_config.php');
 */

// Database configuration constants
define('DB_HOST', 'localhost');
define('DB_NAME', 'twinbeam');
define('DB_USER', 'root');
define('DB_PASS', '');

// Function to create database connection
function getDBConnection() {
    try {
        $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        
        // Check connection
        if ($conn->connect_error) {
            throw new Exception("Connection failed: " . $conn->connect_error);
        }
        
        // Set charset to utf8mb4
        $conn->set_charset("utf8mb4");
        
        return $conn;
    } catch (Exception $e) {
        // Log error
        error_log("Database Connection Error: " . $e->getMessage());
        
        // Display user-friendly error
        die("Sorry, we're experiencing technical difficulties. Please try again later.");
    }
}

// Function for PDO connection (for subscription system)
function getPDOConnection() {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];
        
        $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        return $pdo;
    } catch (PDOException $e) {
        // Log error
        error_log("PDO Connection Error: " . $e->getMessage());
        
        // Display user-friendly error
        die("Sorry, we're experiencing technical difficulties. Please try again later.");
    }
}

// Function to close database connection
function closeDBConnection($conn) {
    if ($conn) {
        $conn->close();
    }
}

// Optional: Function to check if database exists
function checkDatabaseExists() {
    try {
        $conn = new mysqli(DB_HOST, DB_USER, DB_PASS);
        
        if ($conn->connect_error) {
            return false;
        }
        
        $result = $conn->query("SHOW DATABASES LIKE '" . DB_NAME . "'");
        $exists = $result->num_rows > 0;
        
        $conn->close();
        return $exists;
    } catch (Exception $e) {
        error_log("Database Check Error: " . $e->getMessage());
        return false;
    }
}

// Display warning if database doesn't exist (only in development)
if (!checkDatabaseExists() && $_SERVER['SERVER_NAME'] === 'localhost') {
    echo '<div style="background: #f8d7da; color: #721c24; padding: 15px; margin: 10px; border: 1px solid #f5c6cb; border-radius: 5px;">';
    echo '<strong>Database Error:</strong> The database "' . DB_NAME . '" does not exist. ';
    echo 'Please run the setup_database.sql script first.';
    echo '</div>';
}
?><?php
$host = "localhost";
$user = "root";
$pass = "";
$db = "DEFMIS";

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}
?>
