<?php include('includes/header.php'); ?>
<style>
/* Section Title */
.section-title {
  font-size: 1.8rem;
  font-weight: 600;
  color: #004080;
  position: relative;
  display: inline-block;
}

.section-title::after {
  content: '';
  display: block;
  width: 60px;
  height: 3px;
  background: #007bff;
  margin: 10px auto 0;
}

/* Nav Pills */
.nav-pills .nav-item .nav-link {
  border-radius: 50px;
  background-color: #f8f9fa;
  color: #004080;
  border: 2px solid #007bff;
  transition: all 0.3s ease;
}

.nav-pills .nav-item .nav-link.active,
.nav-pills .nav-item .nav-link:hover {
  background-color: #007bff;
  color: #fff;
}

/* Accordion Custom Styles */
.accordion-button {
  background-color: #e9f1fb;
  color: #004080;
  font-weight: 600;
  border: none;
  box-shadow: none;
  transition: background-color 0.3s;
}

.accordion-button:hover {
  background-color: #d0e4fb;
}

.accordion-button:not(.collapsed) {
  background-color: #007bff;
  color: #fff;
}

.accordion-item {
  border: 1px solid #d1e3f8;
  border-radius: 8px;
  margin-bottom: 15px;
  overflow: hidden;
}

.accordion-body {
  background-color: #f9fcff;
  font-size: 1rem;
  color: #333;
  padding: 1rem 1.25rem;
}

.accordion-body ul {
  margin-top: 10px;
  padding-left: 20px;
}

.accordion-body strong {
  color: #004080;
}

/* Responsive adjustments */
@media (max-width: 768px) {
  .nav-pills .nav-item .nav-link span {
    width: auto !important;
    padding: 0 10px;
    font-size: 0.9rem;
  }
}
</style>

<!-- FAQ Section Start -->
<div class="container-fluid destination py-5">
  <div class="container py-5">
      <div class="mx-auto text-center mb-5" style="max-width: 900px;">
          <h5 class="section-title px-3">Frequently Asked Questions</h5>
          <p class="text-muted mt-3">Find answers to common questions about our asset tagging and identification services</p>
      </div>
      
      <div class="tab-class text-center">
          <ul class="nav nav-pills d-inline-flex justify-content-center mb-5 flex-wrap">
              <li class="nav-item">
                  <a class="d-flex mx-2 my-2 py-2 border border-primary bg-light rounded-pill active" data-bs-toggle="pill" href="#tab-1">
                      <span class="text-dark" style="width: 150px;">General Questions</span>
                  </a>
              </li>
              <li class="nav-item">
                  <a class="d-flex py-2 mx-2 my-2 border border-primary bg-light rounded-pill" data-bs-toggle="pill" href="#tab-2">
                      <span class="text-dark" style="width: 150px;">Services</span>
                  </a>
              </li>
              <li class="nav-item">
                  <a class="d-flex mx-2 my-2 py-2 border border-primary bg-light rounded-pill" data-bs-toggle="pill" href="#tab-3">
                      <span class="text-dark" style="width: 150px;">Technical</span>
                  </a>
              </li>
              <li class="nav-item">
                  <a class="d-flex mx-2 my-2 py-2 border border-primary bg-light rounded-pill" data-bs-toggle="pill" href="#tab-4">
                      <span class="text-dark" style="width: 150px;">Implementation</span>
                  </a>
              </li>                     
          </ul>

          <div class="tab-content">
              <!-- Tab 1: General Questions -->
              <div id="tab-1" class="tab-pane fade show p-0 active">
                  <div class="container mt-5">
                      <div class="accordion" id="generalAccordion">
                          
                          <!-- Question 1 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#general1" aria-expanded="true">
                                      What is asset tagging?
                                  </button>
                              </h2>
                              <div id="general1" class="accordion-collapse collapse show" data-bs-parent="#generalAccordion">
                                  <div class="accordion-body">
                                      Asset tagging is the process of labeling physical assets with unique identification tags that help organizations track, manage, and secure their equipment. These tags can include barcodes, QR codes, RFID chips, or engraved serial numbers, enabling fast identification and accurate asset records.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 2 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general2">
                                      Why is asset tagging important for my organization?
                                  </button>
                              </h2>
                              <div id="general2" class="accordion-collapse collapse" data-bs-parent="#generalAccordion">
                                  <div class="accordion-body">
                                      Asset tagging improves asset visibility, accountability, and control. It helps organizations:
                                      <ul>
                                          <li>Reduce asset loss and theft</li>
                                          <li>Track asset location and ownership</li>
                                          <li>Improve audit accuracy</li>
                                          <li>Support preventive maintenance</li>
                                          <li>Enhance asset lifecycle management</li>
                                      </ul>
                                      It also ensures compliance with internal controls and financial reporting standards.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 3 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general3">
                                      What types of asset tags do you provide?
                                  </button>
                              </h2>
                              <div id="general3" class="accordion-collapse collapse" data-bs-parent="#generalAccordion">
                                  <div class="accordion-body">
                                      We provide a wide range of asset tags depending on your environment and security needs, including:
                                      <ul>
                                          <li>Barcode asset tags</li>
                                          <li>QR code asset labels</li>
                                          <li>RFID asset tags</li>
                                          <li>Tamper-evident labels</li>
                                          <li>Metal and polyester industrial tags</li>
                                      </ul>
                                      All our tags are durable, weather-resistant, and designed for long-term use.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 4 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general4">
                                      What types of assets can be tagged?
                                  </button>
                              </h2>
                              <div id="general4" class="accordion-collapse collapse" data-bs-parent="#generalAccordion">
                                  <div class="accordion-body">
                                      We can tag virtually all types of physical assets, including:
                                      <ul>
                                          <li>Computers and IT equipment</li>
                                          <li>Medical and laboratory equipment</li>
                                          <li>Office furniture</li>
                                          <li>Vehicles and fleet equipment</li>
                                          <li>Machinery and tools</li>
                                          <li>Electrical and electronic devices</li>
                                      </ul>
                                      Our team assesses your asset environment and recommends the most suitable tag type.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 5 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#general5">
                                      What industries do you serve?
                                  </button>
                              </h2>
                              <div id="general5" class="accordion-collapse collapse" data-bs-parent="#generalAccordion">
                                  <div class="accordion-body">
                                      We serve a wide range of industries, including:
                                      <ul>
                                          <li>Hospitals and healthcare facilities</li>
                                          <li>Schools and universities</li>
                                          <li>Government institutions</li>
                                          <li>Corporate offices</li>
                                          <li>Manufacturing and logistics</li>
                                          <li>NGOs and development organizations</li>
                                      </ul>
                                  </div>
                              </div>
                          </div>

                      </div>
                  </div>
              </div>

              <!-- Tab 2: Services -->
              <div id="tab-2" class="tab-pane fade show p-0">
                  <div class="container mt-5">
                      <div class="accordion" id="servicesAccordion">
                          
                          <!-- Question 1 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#services1" aria-expanded="true">
                                      Do you offer asset engraving services?
                                  </button>
                              </h2>
                              <div id="services1" class="accordion-collapse collapse show" data-bs-parent="#servicesAccordion">
                                  <div class="accordion-body">
                                      Yes. We provide professional laser and mechanical engraving services for permanent asset identification. Engraving is ideal for high-value or theft-prone assets where permanent marking is required. Our engraving services include:
                                      <ul>
                                          <li>Permanent and tamper-proof identification</li>
                                          <li>High-precision laser engraving</li>
                                          <li>Custom engraving of company name, logo, and asset number</li>
                                          <li>Professional finish without damaging equipment</li>
                                      </ul>
                                      Ideal for laptops, desktops, servers, projectors, medical equipment, power tools, and office devices.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 2 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#services2">
                                      Do you conduct on-site asset tagging?
                                  </button>
                              </h2>
                              <div id="services2" class="accordion-collapse collapse" data-bs-parent="#servicesAccordion">
                                  <div class="accordion-body">
                                      Yes. Our trained technicians perform on-site asset tagging at your premises to ensure accuracy, consistency, and minimal downtime. We work during business hours or after hours based on your preference to minimize operational disruption.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 3 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#services3">
                                      Do you provide asset audits and verification?
                                  </button>
                              </h2>
                              <div id="services3" class="accordion-collapse collapse" data-bs-parent="#servicesAccordion">
                                  <div class="accordion-body">
                                      Yes. We conduct asset audits, verification, and reconciliation services to help you confirm asset existence, condition, and location. Our audit services include physical verification, data capture, and comprehensive reporting.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 4 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#services4">
                                      Do you offer after-sales support?
                                  </button>
                              </h2>
                              <div id="services4" class="accordion-collapse collapse" data-bs-parent="#servicesAccordion">
                                  <div class="accordion-body">
                                      Yes. We provide ongoing support, tag replacements, system updates, and maintenance services to ensure long-term success of your asset management program. Our support team is available to assist with any questions or issues.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 5 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#services5">
                                      Do you supply computers and IT equipment?
                                  </button>
                              </h2>
                              <div id="services5" class="accordion-collapse collapse" data-bs-parent="#servicesAccordion">
                                  <div class="accordion-body">
                                      Yes. We supply a wide range of high-quality computers, peripherals, and accessories including:
                                      <ul>
                                          <li>Desktop computers and laptops</li>
                                          <li>Monitors and display screens</li>
                                          <li>Keyboards, mice, and headsets</li>
                                          <li>Printers and scanners</li>
                                          <li>UPS and power backup solutions</li>
                                          <li>External storage devices</li>
                                      </ul>
                                      All products come with genuine manufacturer warranty, professional installation, and after-sales support.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 6 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#services6">
                                      Do you provide networking solutions?
                                  </button>
                              </h2>
                              <div id="services6" class="accordion-collapse collapse" data-bs-parent="#servicesAccordion">
                                  <div class="accordion-body">
                                      Yes. We deliver end-to-end networking solutions including:
                                      <ul>
                                          <li>Network switches and routers</li>
                                          <li>Structured cabling (LAN & fiber)</li>
                                          <li>Wireless access points</li>
                                          <li>Server racks and cabinets</li>
                                          <li>Network installation and configuration</li>
                                      </ul>
                                      Our networking solutions are designed for reliability, security, and scalability.
                                  </div>
                              </div>
                          </div>

                      </div>
                  </div>
              </div>

              <!-- Tab 3: Technical -->
              <div id="tab-3" class="tab-pane fade show p-0">
                  <div class="container mt-5">
                      <div class="accordion" id="technicalAccordion">
                          
                          <!-- Question 1 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#technical1" aria-expanded="true">
                                      How durable are your asset tags?
                                  </button>
                              </h2>
                              <div id="technical1" class="accordion-collapse collapse show" data-bs-parent="#technicalAccordion">
                                  <div class="accordion-body">
                                      Our asset tags are designed to withstand harsh conditions including:
                                      <ul>
                                          <li>Heat and cold</li>
                                          <li>Moisture and humidity</li>
                                          <li>Chemicals and cleaning agents</li>
                                          <li>Abrasion and frequent handling</li>
                                      </ul>
                                      They are suitable for indoor, outdoor, and industrial environments.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 2 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#technical2">
                                      Can you customize asset tags with our company name and logo?
                                  </button>
                              </h2>
                              <div id="technical2" class="accordion-collapse collapse" data-bs-parent="#technicalAccordion">
                                  <div class="accordion-body">
                                      Yes. We provide fully customized asset tags featuring your:
                                      <ul>
                                          <li>Company name</li>
                                          <li>Logo</li>
                                          <li>Asset numbers</li>
                                          <li>Barcode or QR code</li>
                                          <li>Department or location information</li>
                                      </ul>
                                      This enhances brand visibility and strengthens asset ownership identification.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 3 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#technical3">
                                      Do your asset tags integrate with asset management software?
                                  </button>
                              </h2>
                              <div id="technical3" class="accordion-collapse collapse" data-bs-parent="#technicalAccordion">
                                  <div class="accordion-body">
                                      Yes. Our asset tags are compatible with most asset management and inventory systems. We also assist with system integration, data migration, and staff training to ensure seamless implementation.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 4 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#technical4">
                                      Is your asset tagging solution suitable for regulatory compliance?
                                  </button>
                              </h2>
                              <div id="technical4" class="accordion-collapse collapse" data-bs-parent="#technicalAccordion">
                                  <div class="accordion-body">
                                      Yes. Our solutions support compliance with internal audit requirements, financial reporting standards, and organizational asset governance policies. We follow industry best practices to ensure audit readiness.
                                  </div>
                              </div>
                          </div>

                      </div>
                  </div>
              </div>

              <!-- Tab 4: Implementation -->
              <div id="tab-4" class="tab-pane fade show p-0">
                  <div class="container mt-5">
                      <div class="accordion" id="implementationAccordion">
                          
                          <!-- Question 1 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#implementation1" aria-expanded="true">
                                      How long does an asset tagging project take?
                                  </button>
                              </h2>
                              <div id="implementation1" class="accordion-collapse collapse show" data-bs-parent="#implementationAccordion">
                                  <div class="accordion-body">
                                      Project timelines depend on the number of assets and complexity of your environment. However, most projects are completed within:
                                      <ul>
                                          <li><strong>Small offices:</strong> 1–3 days</li>
                                          <li><strong>Medium organizations:</strong> 1–2 weeks</li>
                                          <li><strong>Large enterprises:</strong> Project-based scheduling</li>
                                      </ul>
                                      We always work to minimize operational disruption.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 2 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#implementation2">
                                      How do we get started?
                                  </button>
                              </h2>
                              <div id="implementation2" class="accordion-collapse collapse" data-bs-parent="#implementationAccordion">
                                  <div class="accordion-body">
                                      Getting started is simple:
                                      <ol>
                                          <li>Contact our team for a consultation</li>
                                          <li>We assess your asset environment</li>
                                          <li>We recommend the best tagging solution</li>
                                          <li>We schedule on-site implementation</li>
                                      </ol>
                                      Our team will work with you to develop a customized solution that meets your specific needs.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 3 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#implementation3">
                                      Will the asset tagging process disrupt our operations?
                                  </button>
                              </h2>
                              <div id="implementation3" class="accordion-collapse collapse" data-bs-parent="#implementationAccordion">
                                  <div class="accordion-body">
                                      No. We work closely with our clients to minimize disruption. Our team follows proven methodologies and can work during off-hours if needed. We ensure consistent, reliable results with minimal impact on your daily operations.
                                  </div>
                              </div>
                          </div>

                          <!-- Question 4 -->
                          <div class="accordion-item">
                              <h2 class="accordion-header">
                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#implementation4">
                                      What information do you need to start a project?
                                  </button>
                              </h2>
                              <div id="implementation4" class="accordion-collapse collapse" data-bs-parent="#implementationAccordion">
                                  <div class="accordion-body">
                                      To begin an asset tagging project, we typically need:
                                      <ul>
                                          <li>Estimated number of assets to be tagged</li>
                                          <li>Types of assets (IT equipment, furniture, vehicles, etc.)</li>
                                          <li>Current asset management system (if any)</li>
                                          <li>Preferred tagging method (barcode, QR code, RFID, engraving)</li>
                                          <li>Timeline and budget considerations</li>
                                          <li>Compliance or reporting requirements</li>
                                      </ul>
                                  </div>
                              </div>
                          </div>

                      </div>
                  </div>
              </div>

          </div>
      </div>
  </div>
</div>

<!-- Contact CTA Section -->
<div class="container-fluid py-5 bg-light">
    <div class="container text-center">
        <h3 class="mb-4">Need More Information?</h3>
        <p class="mb-4">Our team is ready to assist you with a customized asset tagging solution tailored to your organization's needs.</p>
        <div class="row justify-content-center">
            <div class="col-md-3 mb-3">
                <div class="card border-primary h-100">
                    <div class="card-body">
                        <i class="fas fa-phone fa-2x text-primary mb-3"></i>
                        <h5>Call Us Today</h5>
                        <p class="mb-0">Get in touch with our team</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card border-primary h-100">
                    <div class="card-body">
                        <i class="fas fa-envelope fa-2x text-primary mb-3"></i>
                        <h5>Email Us</h5>
                        <p class="mb-0">Send us your inquiries</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card border-primary h-100">
                    <div class="card-body">
                        <i class="fas fa-calendar-check fa-2x text-primary mb-3"></i>
                        <h5>Request a Quote</h5>
                        <p class="mb-0">Get a customized solution</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="mt-4">
            <a href="contact.php" class="btn btn-primary btn-lg px-5">Contact Us Now</a>
        </div>
    </div>
</div>

<script>
  // Smooth scroll to tab content on tab change
  const tabLinks = document.querySelectorAll('[data-bs-toggle="pill"]');
  tabLinks.forEach(tab => {
    tab.addEventListener('shown.bs.tab', function () {
      document.querySelector('.tab-content').scrollIntoView({
        behavior: 'smooth',
        block: 'start'
      });
    });
  });
</script>

<?php include('includes/footer.php'); ?>