<?php include('includes/header.php'); ?>
<?php
$documents = [
  "List of Accredited Hospitals without Co-Pay" => "img/Documents/DEFMIS_HOSPITALS_WITHOUT_CO_PAY.pdf",
  "List of Accredited Hospitals" => "img/Documents/DEFMIS_ACCREDITED_HOSPITALS_AS_AT_30_MAY_2025.pdf",
  "DEFMIS Members Guidelines" => "img/Documents/DEFMIS_Members_Guidelines_30_MAY_2025.pdf",
  "Application Form" => "img/Documents/DEFMIS_MEMBERSHIP_APPLICATION_FORCES_FORM_55.pdf",
  "DEFMIS Brochure" => "img/Documents/DEFMIS_BROCHURE.pdf",
  "Certificate of Existence" => "img/Documents/CERTIFICATE_OF_EXISTENCE.pdf",
  "Members Declaration Form" => "img/Documents/MEMBERS_DECLARATION_FORM.pdf",
  "Portal Manual" => "img\Documents\DEFMIS_HOSPITALS_WEB_PORTAL_PRESENTATION.pptx",
  "Defmis Mobile App" => "img\Documents\defmis.apk",
  "Mobile App User Manual" => "img/Documents/DEFMIS_MOBILE_APP_USER_MANUAL.pdf"
];
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>DEFMIS Downloads</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light p-4">

  <div class="container">
    <h3 class="mb-4 text-primary">DEFMIS Downloads</h3>
    <table class="table table-bordered table-striped table-hover">
      <thead class="table-dark">
        <tr>
          <th>S/No</th>
          <th>Name</th>
          <th>Download Link</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $sn = 1;
        foreach ($documents as $title => $link) {
          echo "<tr>
                  <td>{$sn}</td>
                  <td>{$title}</td>
                  <td><a href=\"{$link}\" class=\"btn btn-sm btn-outline-primary\" target=\"_blank\">Download</a></td>
                </tr>";
          $sn++;
        }
        ?>
      </tbody>
    </table>
  </div>

</body>
</html>
<div class="no-print">
    <?php include('includes/footer.php'); ?>
</div>