<?php include('includes/header.php'); ?>
<!-- Add in your <head> section -->
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

<style>
.hero-section {
  position: relative;
  height: 300px;
  background: url('img/about-hero.jpg') center center/cover no-repeat;
}
.hero-section .overlay {
  position: absolute;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0,0,0,0.6);
}
.hero-section .breadcrumb {
  background: transparent;
  margin-top: 15px;
}
.hero-section .breadcrumb-item + .breadcrumb-item::before {
  color: #ffffff;
}
.section-hr {
  border: 1px solid #fff;
  opacity: 1;
  width: 100px;
  margin: 20px auto;
}
.fade-in {
  opacity: 0;
  animation: fadeIn 1.2s ease forwards;
}
@keyframes fadeIn {
  to {
    opacity: 1;
  }
}
</style>

<!-- HERO SECTION -->
<section class="hero-section text-center text-white d-flex align-items-center justify-content-center">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-5 fw-bold">About Twin Beam Enterprises</h1>
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-center">
        <li class="breadcrumb-item"><a href="index.php" class="text-white text-decoration-underline">Home</a></li>
        <li class="breadcrumb-item active text-white" aria-current="page">About Us</li>
      </ol>
    </nav>
  </div>
</section>

<style>
#about-page-content .hr {
    height: 10px;
    border-width: 0;
    background-color: #469DFF;
}

#about-page-content .hr2 { background-color: #ff0000; }
#about-page-content .hr3 { background-color: #000000; }
#about-page-content .hr4 { background-color: #008000; }
#about-page-content .hr5 { height: 5px; background-color: #FFFFFF; }
#about-page-content .hr6 { background-color: #000066; }
</style>

<div id="about-page-content">

  <!-- Company Overview Section -->
  <div style="max-width:1300px; margin:40px auto; padding:10px;">
    <div style="text-align:center; margin-bottom:40px;">
      <h2 style="font-size:32px; font-weight:bold; color:#004080; margin-bottom:20px;">Who We Are</h2>
      <div class="hr" style="width:100px; margin:0 auto 30px;"></div>
      <p style="font-size:18px; line-height:1.8; color:#555; max-width:900px; margin:0 auto;">
        Twin Beam Enterprises is a registered company in Kenya that specializes in the provision of cost-effective products and services ranging from asset tagging, computers and accessories, networking, printing/branding services, and supply of stationeries among others.
      </p>
    </div>

    <!-- Mission & Vision -->
    <div style="display:flex; gap:30px; flex-wrap:wrap; justify-content:center; margin:60px 0;">
      
      <!-- Mission -->
      <div style="flex:1; min-width:300px; max-width:500px; background:#f8f9fa; padding:40px; border-radius:12px; box-shadow:0 4px 12px rgba(0,0,0,0.1);">
        <div style="text-align:center; margin-bottom:20px;">
          <div style="width:80px; height:80px; background:#004080; border-radius:50%; margin:0 auto 20px; display:flex; align-items:center; justify-content:center;">
            <svg xmlns="http://www.w3.org/2000/svg" fill="#fff" viewBox="0 0 24 24" width="40" height="40">
              <path d="M12 2C8.2 2 5.3 4.5 4 8c.6-.2 1.2-.4 1.8-.5C8 9 10 11.2 12 14c2.1-2.6 4.1-4.8 6.3-6.4.6.1 1.2.3 1.7.5C18.7 4.5 15.8 2 12 2zm0 20c-1.6 0-3.1-.5-4.4-1.3.2-.5.4-1 .6-1.5.9-1.9 2.2-3.8 3.8-5.6 1.6 1.7 2.9 3.6 3.8 5.5.2.5.4 1 .6 1.5C15.1 21.5 13.6 22 12 22z"/>
            </svg>
          </div>
          <h3 style="font-size:24px; font-weight:bold; color:#004080; margin-bottom:15px;">Our Mission</h3>
        </div>
        <p style="font-size:16px; line-height:1.7; color:#555; text-align:center;">
          Twin Beam Enterprises exists to provide qualitative, affordable, professional and real-time solutions and related support services to our customers in Kenya and beyond.
        </p>
      </div>

      <!-- Vision -->
      <div style="flex:1; min-width:300px; max-width:500px; background:#f8f9fa; padding:40px; border-radius:12px; box-shadow:0 4px 12px rgba(0,0,0,0.1);">
        <div style="text-align:center; margin-bottom:20px;">
          <div style="width:80px; height:80px; background:#469DFF; border-radius:50%; margin:0 auto 20px; display:flex; align-items:center; justify-content:center;">
            <svg xmlns="http://www.w3.org/2000/svg" fill="#fff" viewBox="0 0 24 24" width="40" height="40">
              <path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/>
            </svg>
          </div>
          <h3 style="font-size:24px; font-weight:bold; color:#004080; margin-bottom:15px;">Our Vision</h3>
        </div>
        <p style="font-size:16px; line-height:1.7; color:#555; text-align:center;">
          Our character is to share values, with a major aim of growing into Kenya's most customer-centric branding company of choice.
        </p>
      </div>

    </div>
  </div>

  <div class="hr2" style="margin:60px 0;"></div>

 
  <div class="hr3" style="margin:60px 0;"></div>

  <!-- Why Choose Us Section -->
  <div style="max-width:1200px; margin:60px auto; padding:20px;">
    <h2 style="text-align:center; font-size:28px; font-weight:bold; color:#004080; margin-bottom:40px;">
      Why Choose Twin Beam Enterprises
    </h2>

    <div style="display:flex; flex-direction:column; gap:20px;">

      <!-- Reason 1 -->
      <div style="display:flex; align-items:center; background:#d98841; color:#fff; border-radius:8px; overflow:hidden;">
        <div style="background:#c07a39; padding:20px 30px; font-weight:bold; font-size:20px; display:flex; flex-direction:column; align-items:center; justify-content:center;">
          <div>01</div>
          <div style="font-size:22px; margin-top:6px;">👥</div>
        </div>
        <div style="flex:1; padding:20px 25px;">
          <div style="font-weight:bold; font-size:18px;">Professional Team</div>
          <div style="font-size:14px;">We pride ourselves backed by a professional team of all requisite areas of our operations.</div>
        </div>
      </div>

      <!-- Reason 2 -->
      <div style="display:flex; align-items:center; background:#2f3f61; color:#fff; border-radius:8px; overflow:hidden;">
        <div style="background:#26344f; padding:20px 30px; font-weight:bold; font-size:20px; display:flex; flex-direction:column; align-items:center; justify-content:center;">
          <div>02</div>
          <div style="font-size:22px; margin-top:6px;">⭐</div>
        </div>
        <div style="flex:1; padding:20px 25px;">
          <div style="font-weight:bold; font-size:18px;">Customer-Centric Approach</div>
          <div style="font-size:14px;">We have the best approach to customer complaints with preference to satisfaction as opposed to sales volumes.</div>
        </div>
      </div>

      <!-- Reason 3 -->
      <div style="display:flex; align-items:center; background:#93463f; color:#fff; border-radius:8px; overflow:hidden;">
        <div style="background:#763a34; padding:20px 30px; font-weight:bold; font-size:20px; display:flex; flex-direction:column; align-items:center; justify-content:center;">
          <div>03</div>
          <div style="font-size:22px; margin-top:6px;">🕐</div>
        </div>
        <div style="flex:1; padding:20px 25px;">
          <div style="font-weight:bold; font-size:18px;">Extended Support</div>
          <div style="font-size:14px;">We always extend our working hours should need arise to sort a client issue.</div>
        </div>
      </div>

      <!-- Reason 4 -->
      <div style="display:flex; align-items:center; background:#d98841; color:#fff; border-radius:8px; overflow:hidden;">
        <div style="background:#c07a39; padding:20px 30px; font-weight:bold; font-size:20px; display:flex; flex-direction:column; align-items:center; justify-content:center;">
          <div>04</div>
          <div style="font-size:22px; margin-top:6px;">✓</div>
        </div>
        <div style="flex:1; padding:20px 25px;">
          <div style="font-weight:bold; font-size:18px;">Trusted & Reliable</div>
          <div style="font-size:14px;">We have no past or present litigation cases and clean legal background information.</div>
        </div>
      </div>

    </div>
  </div>

  <div class="hr4" style="margin:60px 0;"></div>

  <!-- Company History Timeline -->
  <div style="font-family: Georgia, serif; background-color: #fffdf8; color: #111; max-width: 1000px; margin: 60px auto; padding: 40px 20px; border: 1px solid #ccc; box-shadow: 0 0 12px rgba(0,0,0,0.05); line-height: 1.6;">
    
    <div style="text-align: center; font-size: 30px; font-weight: bold; border-bottom: 2px solid #999; padding-bottom: 12px; margin-bottom: 40px;">
      Our Journey – From Vision to Reality
    </div>

    <div style="position: relative; padding-left: 60px;">
      <div style="position: absolute; top: 0; bottom: 0; left: 35px; width: 3px; background-color: #bbb;"></div>

      <!-- Milestone 1 -->
      <div style="display: flex; flex-wrap: wrap; margin-bottom: 60px; position: relative;">
        <div style="position: absolute; left: 18px; top: 0; width: 36px; height: 36px; background-color: #e0e0e0; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
          <svg xmlns="http://www.w3.org/2000/svg" fill="#004080" viewBox="0 0 24 24" width="18" height="18"><path d="M12 2C8.2 2 5.3 4.5 4 8c.6-.2 1.2-.4 1.8-.5C8 9 10 11.2 12 14c2.1-2.6 4.1-4.8 6.3-6.4.6.1 1.2.3 1.7.5C18.7 4.5 15.8 2 12 2zm0 20c-1.6 0-3.1-.5-4.4-1.3.2-.5.4-1 .6-1.5.9-1.9 2.2-3.8 3.8-5.6 1.6 1.7 2.9 3.6 3.8 5.5.2.5.4 1 .6 1.5C15.1 21.5 13.6 22 12 22z"/></svg>
        </div>
        <div style="margin-left: 60px; flex: 1; min-width: 240px;">
          <div style="font-size: 20px; font-weight: bold; color: #004080;">Company Establishment</div>
          <div style="margin-top: 8px; font-size: 16px;">
            Twin Beam Enterprises was established in response to the growing market demand for high quality innovative solutions at affordable prices.
          </div>
        </div>
      </div>

      <!-- Milestone 2 -->
      <div style="display: flex; flex-wrap: wrap; margin-bottom: 60px; position: relative;">
        <div style="position: absolute; left: 18px; top: 0; width: 36px; height: 36px; background-color: #e0e0e0; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
          <svg xmlns="http://www.w3.org/2000/svg" fill="#004080" viewBox="0 0 24 24" width="18" height="18"><path d="M5 4h14v2H5zM5 11h14v2H5zM5 18h14v2H5z"/></svg>
        </div>
        <div style="margin-left: 60px; flex: 1; min-width: 240px;">
          <div style="font-size: 20px; font-weight: bold; color: #004080;">Service Expansion</div>
          <div style="margin-top: 8px; font-size: 16px;">
            Our commitment to refining development has allowed us to introduce a wide range of products as well as customized solutions that enable businesses to simplify their operations.
          </div>
        </div>
      </div>

      <!-- Milestone 3 -->
      <div style="display: flex; flex-wrap: wrap; margin-bottom: 60px; position: relative;">
        <div style="position: absolute; left: 18px; top: 0; width: 36px; height: 36px; background-color: #e0e0e0; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
          <svg xmlns="http://www.w3.org/2000/svg" fill="#004080" viewBox="0 0 24 24" width="18" height="18"><path d="M21 3H3v18h18V3zm-2 16H5V5h14v14z"/></svg>
        </div>
        <div style="margin-left: 60px; flex: 1; min-width: 240px;">
          <div style="font-size: 20px; font-weight: bold; color: #004080;">Building Partnerships</div>
          <div style="margin-top: 8px; font-size: 16px;">
            With business experience and an ongoing relationship with well-established companies, our staff have worked with business-leading companies to acquire an in-depth understanding of the latest technologies and processes.
          </div>
        </div>
      </div>

    </div>
  </div>

 

<?php include('includes/footer.php'); ?>